/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.remotesupport.inconn;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.remotesupport.inconn.InboundConnectivityConstants;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.rcs.conndata.CecInfo;
import com.ibm.hwmca.fw.rcs.conndata.LparInfo;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.List;

public class RssfSessionBean
extends PanelBean
implements InboundConnectivityConstants {
    private static final String TRACE_MASKT = "JRCSRSBT";
    private static final String TRACE_MASKF = "JRCSRSBF";
    private static final String TRACE_MASKD = "JRCSRSBD";
    private static final ClassLogInfo classLogInfo = new ClassLogInfo(-88, -124, "RCS-RsvSBean");
    private String connectionType;
    private String pppAddress;
    private boolean consoleAccess = false;
    private boolean lparAccess = false;
    private CecInfo consoleInfo = null;
    private CecInfo managedSystemInfo = null;
    private boolean sessionInProgress = false;
    private boolean sessionConnected = false;
    private boolean sessionStopping = false;
    private Object statusLock;
    private LocalizableText enabledText = new LocalizableText("com.ibm.hsc.common.bundles.RemoteSupportBundle", "STATUS_ENABLED");
    private LocalizableText disabledText = new LocalizableText("com.ibm.hsc.common.bundles.RemoteSupportBundle", "STATUS_DISABLED");
    private String m_sConsoleStatus;
    private String m_sManagedSystem;
    private transient ItemDescriptor[][] m_idPartitionsTable;
    private transient ColumnDescriptor[] m_cdPartitionsTableStructure;
    private int[] m_iPartitionsTableSelection;
    private String m_sSessionStatus;

    public RssfSessionBean() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> RssfSessionBean()");
    }

    public void setConsoleStatus(String string) throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKF, (Object)("<> setConsoleStatus(" + string + ")"));
        this.m_sConsoleStatus = string;
    }

    public String getConsoleStatus() {
        return this.m_sConsoleStatus;
    }

    public void setManagedSystem(String string) throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKF, (Object)("<> setManagedSystem(" + string + ")"));
        this.m_sManagedSystem = string;
    }

    public String getManagedSystem() {
        return this.m_sManagedSystem;
    }

    public void setPartitionsTableSelection(int[] nArray) throws IllegalUserDataException {
        this.m_iPartitionsTableSelection = nArray;
    }

    public int[] getPartitionsTableSelection() {
        return this.m_iPartitionsTableSelection;
    }

    public void setPartitionsTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.m_idPartitionsTable[n] = itemDescriptorArray;
    }

    public ItemDescriptor[] getPartitionsTableRowAt(int n) {
        return this.m_idPartitionsTable[n];
    }

    public int getPartitionsTableRowCount() {
        return this.m_idPartitionsTable.length;
    }

    public int getPartitionsTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getPartitionsTableRowStructure() {
        return this.m_cdPartitionsTableStructure;
    }

    public void setSessionStatus(String string) throws IllegalUserDataException {
        this.m_sSessionStatus = string;
    }

    public String getSessionStatus() {
        return this.m_sSessionStatus;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> verifyChanges()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- verifyChanges()");
    }

    public void load() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> load()");
        this.m_sConsoleStatus = "";
        this.m_sManagedSystem = "";
        this.m_idPartitionsTable = new ItemDescriptor[0][0];
        this.m_cdPartitionsTableStructure = new ColumnDescriptor[0];
        this.m_iPartitionsTableSelection = new int[0];
        this.m_sSessionStatus = "";
        Trace.trace((String)TRACE_MASKT, (Object)"<- load()");
    }

    public void save() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> save()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- save()");
    }

    public void setConnectionType(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setConnectionType(" + string + ")"));
        this.connectionType = string;
    }

    public void setPppAddress(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setPppAddress(" + string + ")"));
        this.pppAddress = string;
    }

    public void setConsoleAccess(boolean bl) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setConsoleAccess(" + bl + ")"));
        this.consoleAccess = bl;
    }

    public void setLparAccess(boolean bl) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setLparAccess(" + bl + ")"));
        this.lparAccess = bl;
    }

    public void setConsoleInfo(CecInfo cecInfo) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setConsoleInfo(" + cecInfo + ")"));
        this.consoleInfo = cecInfo;
    }

    public void setManagedSystemInfo(CecInfo cecInfo) {
        if (cecInfo != null) {
            Trace.trace((String)TRACE_MASKT, (Object)("<> setManagedSystemInfo(" + cecInfo + ")"));
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)"<> setManagedSystemInfo(none)");
        }
        this.managedSystemInfo = cecInfo;
    }

    public void prepare() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> prepare()");
        this.statusLock = new Object();
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        Trace.trace((String)TRACE_MASKT, (Object)"<- prepare()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelAction(TaskActionEvent taskActionEvent) {
        block11: {
            Trace.trace((String)TRACE_MASKT, (Object)("-> panelAction(" + taskActionEvent + ")"));
            try {
                String string = taskActionEvent.getElementName();
                if (string.endsWith("StartButton")) {
                    if (!this.sessionInProgress) {
                        this.sessionInProgress = true;
                        this.sessionConnected = false;
                        this.sessionStopping = false;
                        this.m_sSessionStatus = "";
                        this.updateUTMElements();
                        PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                        panelTaskletRequest.setSource((Object)"RssfSessionBean");
                        panelTaskletRequest.setData("Source", (Object)"RssfSessionPanel");
                        panelTaskletRequest.setData("Command", (Object)"Start");
                        panelTaskletRequest.setData("ConnectionType", (Object)this.connectionType);
                        panelTaskletRequest.setData("PppAddress", (Object)this.pppAddress);
                        panelTaskletRequest.setData("AllowConsole", (Object)new Boolean(this.consoleAccess));
                        panelTaskletRequest.setData("ConsoleInfo", (Object)this.consoleInfo);
                        panelTaskletRequest.setData("CecInfo", (Object)this.managedSystemInfo);
                        this.postTaskletRequest(panelTaskletRequest);
                    }
                    break block11;
                }
                if (string.endsWith("StopButton")) {
                    PanelTaskletRequest panelTaskletRequest;
                    if (!this.sessionStopping) {
                        this.sessionStopping = true;
                        panelTaskletRequest = new LocalizableText("com.ibm.hwmca.fw.rcs.inconn.res.InboundConnMsgs", "SESSION_STOP");
                        Object object = this.statusLock;
                        synchronized (object) {
                            this.m_sSessionStatus = this.m_sSessionStatus.concat("\n" + panelTaskletRequest.toString());
                            this.updateUTMElements();
                        }
                    }
                    panelTaskletRequest = new PanelTaskletRequest();
                    panelTaskletRequest.setSource((Object)"RssfSessionBean");
                    panelTaskletRequest.setData("Source", (Object)"RssfSessionPanel");
                    panelTaskletRequest.setData("Command", (Object)"Stop");
                    this.postTaskletRequest(panelTaskletRequest);
                    break block11;
                }
                if (string.endsWith("CancelButton")) {
                    PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                    panelTaskletRequest.setSource((Object)"RssfSessionBean");
                    panelTaskletRequest.setData("Source", (Object)"RssfSessionPanel");
                    panelTaskletRequest.setData("Command", (Object)"Cancel");
                    this.postTaskletRequest(panelTaskletRequest);
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"Unknown element");
                }
            }
            catch (RuntimeException runtimeException) {
                new AusMicrocodeLog(classLogInfo, 5, runtimeException).writeEntryFromTaskletClient();
                this.dispose();
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- panelAction()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object object) {
        block12: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> update");
            try {
                HashMap hashMap = (HashMap)object;
                String string = (String)hashMap.get("Command");
                if (string == null) {
                    string = "";
                }
                Trace.trace((String)TRACE_MASKF, (Object)("command=" + string));
                if (string.equals("")) {
                    Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
                    break block12;
                }
                if (string.equals("UpdateStatus")) {
                    LocalizableText localizableText = (LocalizableText)hashMap.get("StatusInfo");
                    if (localizableText == null) break block12;
                    Object object2 = this.statusLock;
                    synchronized (object2) {
                        this.m_sSessionStatus = this.m_sSessionStatus.equals("") ? localizableText.toString() : this.m_sSessionStatus.concat("\n" + localizableText.toString());
                        this.updateUTMElements();
                        break block12;
                    }
                }
                if (string.equals("SessionOpen")) {
                    this.sessionConnected = true;
                    this.updateDataBeanInfo(false);
                    this.updateUTMElements();
                } else if (string.equals("SessionComplete")) {
                    this.sessionInProgress = false;
                    this.sessionConnected = false;
                    this.updateDataBeanInfo(false);
                    this.updateUTMElements();
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
                }
            }
            catch (RuntimeException runtimeException) {
                new AusMicrocodeLog(classLogInfo, 5, runtimeException).writeEntryFromTaskletClient();
                this.dispose();
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- update");
    }

    private void updateDataBeanInfo(boolean bl) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> updateDataBeanInfo(" + bl + ")"));
        String string = this.enabledText.toString();
        String string2 = this.disabledText.toString();
        this.m_sConsoleStatus = this.consoleAccess ? (this.sessionConnected ? string : string2) : string2;
        if (this.lparAccess && this.managedSystemInfo != null) {
            this.m_sManagedSystem = this.managedSystemInfo.getDisplayName();
            List list = this.managedSystemInfo.getPartitions();
            int n = list.size();
            Trace.trace((String)TRACE_MASKF, (Object)("partitions=" + n));
            this.m_idPartitionsTable = new ItemDescriptor[n][3];
            for (int i = 0; i < n; ++i) {
                LparInfo lparInfo = (LparInfo)list.get(i);
                String string3 = lparInfo.getNumber();
                this.m_idPartitionsTable[i][0] = new ItemDescriptor(null, string3);
                String string4 = lparInfo.getUserName();
                this.m_idPartitionsTable[i][1] = new ItemDescriptor(null, string4);
                String string5 = this.sessionConnected ? string : string2;
                this.m_idPartitionsTable[i][2] = new ItemDescriptor(null, string5);
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> updateUTMElements()");
        if (this.userTaskManager != null) {
            String string = this.getMountPrefix();
            if (this.consoleAccess) {
                this.userTaskManager.setEnabled(string + "ConsoleStatus", true);
            } else {
                this.userTaskManager.setEnabled(string + "ConsoleStatus", false);
            }
            if (this.lparAccess && this.managedSystemInfo != null) {
                this.userTaskManager.setEnabled(string + "ManagedSystem", true);
                this.userTaskManager.setEnabled(string + "PartitionsTable", true);
            } else {
                this.userTaskManager.setEnabled(string + "ManagedSystem", false);
                this.userTaskManager.setEnabled(string + "PartitionsTable", false);
            }
            if (this.sessionInProgress) {
                this.userTaskManager.setEnabled(string + "StartButton", false);
                this.userTaskManager.setEnabled(string + "StopButton", true);
            } else {
                this.userTaskManager.setEnabled(string + "StartButton", true);
                this.userTaskManager.setEnabled(string + "StopButton", false);
            }
            this.userTaskManager.refreshAllElements();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- updateUTMElements()");
    }
}

